<?php
/**
 * XenForo Add-on Merge Double User Post
 *
 * @category XenForo Add-on
 * @package    XfRu_MergeDoubleUserPost
 * @copyright  Copyright (c) 2010 XF-Russia. (http://www.xf-russia.ru)
 * @license
 * @version   $Id: Install.php 60 2010-12-18 09:29:22Z pepelac $ $Date: 2010-12-18 10:29:22 +0100 (Sat, 18 Dec 2010) $ $Revision: 60 $
 * @author Pepelac
 *
 */

class XfRu_MergeDoubleUserPost_Install
{
	public static function install($existingAddon, $addonData)
	{
		if (!empty($existingAddon))
		{
			self::upgrade($existingAddon, $addonData);
		} else {
			$db = XenForo_Application::get('db');

			$db->query("
				CREATE TABLE IF NOT EXISTS `xfr_cronjob` (
				  `job_id` VARCHAR( 25 ) NOT NULL ,
				  `last_run` INT( 10 ) NOT NULL ,
				  `addon_id` VARCHAR( 25 ) NOT NULL ,
				  INDEX (  `job_id` ,  `addon_id` )
				) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
			");

			$db->query("INSERT INTO xfr_cronjob (job_id, last_run, addon_id) VALUES ('xfr_dpp_cleanup', 0, 'XfRuMergeDoubleUserPost')");

		    unset($db);
		}
	}

	public static function uninstall()
	{
		// clean messages from [MERGETIME] tag
		$cleanUpModel = XenForo_Model::create('XfRu_MergeDoubleUserPost_Model_CleanUp');
		$cleanUpModel->replaceMergetimeTag(true);

		$db = XenForo_Application::get('db');

	    $db->query("
	        DELETE FROM `xfr_cronjob` WHERE `addon_id` = 'XfRuMergeDoubleUserPost';
	    ");

	    unset($db);
	}

	public static function upgrade($existingAddon, $addonData)
	{
		// updating to version 1.2.0
		if ($existingAddon['version_id'] < 120 && $addonData['version_id'] == 120)
		{
			$db = XenForo_Application::get('db');

			$db->query("
				CREATE TABLE IF NOT EXISTS `xfr_cronjob` (
				  `job_id` VARCHAR( 25 ) NOT NULL ,
				  `last_run` INT( 10 ) NOT NULL ,
				  `addon_id` VARCHAR( 25 ) NOT NULL ,
				  INDEX (  `job_id` ,  `addon_id` )
				) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
			");

			$db->query("INSERT INTO xfr_cronjob (job_id, last_run, addon_id) VALUES ('xfr_dpp_cleanup', 0, 'XfRuMergeDoubleUserPost')");

		    unset($db);
		}
	}
}